/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// feature conv functions

#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"

HRESULT TestSimpleBlend()
{

	START_METHOD("TestSimpleBlend")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("Select edges for constant radius blend");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	ISet *pEdgeSet = NULL;
	status = activeGraphicDoc->GetSelection(GetBSTR("Edge"), &pEdgeSet);
	CHECK_RETURN_STATUS(status)

	IBlend *pBlend = NULL;
	status = ConstantRadiusBlending(pEdgeSet, FALSE, FALSE, FALSE, FALSE, FALSE, 0.025, "const blend", &pBlend);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Blending");
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("TestSimpleBlend")
}

HRESULT TestVariableBlend()
{

	START_METHOD("TestVariableBlend")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("Select edges for Variable radius blend");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)
	
	ISet *pEdgeSet = NULL;
	status = activeGraphicDoc->GetSelection(GetBSTR("Edge"), &pEdgeSet);
	CHECK_RETURN_STATUS(status)

	double values[2] = {0.025, 0.008 };
	double params[2] = {0.2, 0.8};

	IBlend *pBlend = NULL;
	status = VariableRadiusBlending(pEdgeSet, FALSE, FALSE, FALSE, FALSE, FALSE, values, params, 2, "variable blend", &pBlend);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Blending");
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("TestVariableBlend")
}

HRESULT TestHollow() 
{

	START_METHOD("TestHollow")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox ("Select Top Face ");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	ISet *pFaceSet = NULL;
	status = activeGraphicDoc->GetSelection(GetBSTR("Face"), &pFaceSet);
	CHECK_RETURN_STATUS(status)

	IHollow *pHollow = NULL;
	status = CreateHollow(pFaceSet, 0.0005, "hollowConFunc", &pHollow);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Hollow");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("TestHollow")
}

HRESULT  TestUseComponent()
{

	START_METHOD("TestUseComponent")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("Use Add Component from Assembly Menu and Select the Component");

	status = CommitToProDESKTOP("Add Component", TRUE);
	CHECK_RETURN_STATUS(status)

	IGraphic *pComponent = NULL;
	status = activeGraphicDoc->GetSingleSelection(GetBSTR("DesignInstance"), &pComponent);
	CHECK_RETURN_STATUS(status)

	ITool *pUseComponent = NULL;
	status = UseComponent(CAST(IDesignInstance, pComponent), 1, TRUE, "toolTestConFunc", &pUseComponent);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Use Component");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("TestUseComponent")
}

HRESULT  TestUncondemnAll()
{

	START_METHOD("TestUncondemnAll")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("Use Add Component from Assembly Menu and Select the component");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	IGraphic *pComponent = NULL;
	status = activeGraphicDoc->GetSingleSelection(GetBSTR("DesignInstance"), &pComponent);
	CHECK_RETURN_STATUS(status)

	ITool *pUseComponent = NULL;
	status = UseComponent(CAST(IDesignInstance, pComponent), 1, TRUE, "toolTestConFunc", &pUseComponent);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Use Component");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	// Test UncondemnAll
	IOperation *pOperation = CAST(IOperation, pUseComponent);

	status = pOperation->SetCondemned(TRUE);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("See the Feature Browser  .. The Tool is Condemned");
	
	status = CommitToProDESKTOP("UnCondemn All", TRUE);
	CHECK_RETURN_STATUS(status)

	UncondemnAll();

	status = CommitToProDESKTOP("UnCondemn All");
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("See the Feature Browser ..  UncondemnAll tested");

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("TestUncondemnAll")
}

HRESULT TestHole()
{

	START_METHOD("TestHole")

	HRESULT status=CONV_SUCCESS;

	IPartDocument *activePart = NULL;
	IGraphicDocument *activeGraphicDoc = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign= NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	IPartOthers *part = CAST(IPartOthers, activePart);

	AfxMessageBox("Select the Top Face");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	ISet *pFaceSet= NULL;
	status = activeGraphicDoc->GetSelection(GetBSTR("Face"), &pFaceSet);
	CHECK_RETURN_STATUS(status)

	IIt *pIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(pFaceSet, &pIt);
	CHECK_RETURN_STATUS(status)

	IDispatch *pFace= NULL;
	status = pIt->start(&pFace);
	CHECK_RETURN_STATUS(status)

	IGeometric *localGeometric = CAST(IGeometric, pFace);

	IGeometry *pGeom= NULL;
	status = localGeometric->GetGeometricForm(&pGeom);
	CHECK_RETURN_STATUS(status)

	IWorkplane *prefPlane = NULL;
	CString workplaneName = "dspaceWP2";

	status = pDesign->CreateWorkplane(CAST(IPlane, pGeom), workplaneName.AllocSysString(), &prefPlane);
	CHECK_RETURN_STATUS(status)

	ISketch *pHoleSketch = NULL;
	CString sketchName = "ProfileSketch";

	status = prefPlane->CreateSketch(sketchName.AllocSysString(), &pHoleSketch);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Create Sketch");
	CHECK_RETURN_STATUS(status)

	IVector *pVector = NULL;
	status = (GetCLASS(Vector))->CreateVector(0, 0, 0, &pVector);
	CHECK_RETURN_STATUS(status)

	IVector *pLocalCenter = NULL;
	status = prefPlane->Get3DVector(pVector, &pLocalCenter);
	CHECK_RETURN_STATUS(status)

	localGeometric = CAST(IGeometric, prefPlane);

	// get the geometry
	IGeometry *pPlane = NULL;
	status = localGeometric->GetGeometry (&pPlane);
	CHECK_RETURN_STATUS(status)

	double radius = 0.01;

	IDirection *pPlaneNormal = NULL;
	status = CAST(IPlane, pPlane)->GetNormal(&pPlaneNormal);
	CHECK_RETURN_STATUS(status)

	IBasicCircle *pCurve =NULL;
	status = (GetCLASS(BasicCircle))->CreateBasicCircle(pLocalCenter, pPlaneNormal, radius, &pCurve);
	CHECK_RETURN_STATUS(status)

	status = part->SetState(1);
	CHECK_RETURN_STATUS(status)

	ILine *pCircle = NULL;
	//status = activeSketch->CreateLine(pCurve, &pCircle);
	status = pHoleSketch->CreateLine(CAST(ICurve, pCurve), &pCircle);
	CHECK_RETURN_STATUS(status)

	IHole *pHole1 = NULL;
	status = CreateHole(pHoleSketch, pFaceSet, 1, 0, 1, 0.03, 0, 0, 0, 0, 0, 0, "holeName", &pHole1);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("CreateHole");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("TestHole")
}

HRESULT TestProjection()
{

	START_METHOD("TestProjection")

	HRESULT status = CONV_SUCCESS;

	IPartDocument *activePart = NULL;
	IGraphicDocument *activeGraphicDoc = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	// get the application zobject
	IPartOthers *part = CAST(IPartOthers, activePart);

	AfxMessageBox("Select the Top Face");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	ISet *pFaceSet = NULL;
	status = activeGraphicDoc->GetSelection(GetBSTR("Face"), &pFaceSet);
	CHECK_RETURN_STATUS(status)

	IIt *pIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(pFaceSet, &pIt);
	CHECK_RETURN_STATUS(status)

	IDispatch *pFace = NULL;
	status = pIt->start(&pFace);
	CHECK_RETURN_STATUS(status)

	IGeometric *localGeometric = CAST(IGeometric, pFace);

	IGeometry *pGeom = NULL;
	status = localGeometric->GetGeometricForm(&pGeom);
	CHECK_RETURN_STATUS(status)

	/* offset the plane */
	IWorkplane *pPrefPlane = NULL;
	CString workplaneName = "dspaceWP2";

	status = pDesign->CreateWorkplane(CAST(IPlane, pGeom), workplaneName.AllocSysString(), &pPrefPlane);
	CHECK_RETURN_STATUS(status)

	ISketch *pProjection = NULL;
	CString sketchName = "ProfileSketch";

	status = pPrefPlane->CreateSketch(sketchName.AllocSysString(), &pProjection);
	CHECK_RETURN_STATUS(status)

	status = activeGraphicDoc->SetActiveSketch(pProjection);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("CreateSketch");
	CHECK_RETURN_STATUS(status)

	IVector *pVector = NULL;
	status = (GetCLASS(Vector))->CreateVector(0, 0, 0, &pVector);
	CHECK_RETURN_STATUS(status)

	IVector *pLocalCenter = NULL;
	status = pPrefPlane->Get3DVector(pVector, &pLocalCenter);
	CHECK_RETURN_STATUS(status)

	localGeometric = CAST(IGeometric, pPrefPlane);

	// get the geometry
	IGeometry *pPlane = NULL;
	status = localGeometric->GetGeometry (&pPlane);
	CHECK_RETURN_STATUS(status)

	double radius = 0.02;

	IPlane *plane = CAST(IPlane, pPlane);

	IDirection *pPlaneNormal = NULL;
	status = plane->GetNormal(&pPlaneNormal);
	CHECK_RETURN_STATUS(status)

	IBasicCircle *pCurve = NULL;
	status = (GetCLASS(BasicCircle))->CreateBasicCircle(pLocalCenter, pPlaneNormal, radius, &pCurve);
	CHECK_RETURN_STATUS(status)

	status = part->SetState(1);
	CHECK_RETURN_STATUS(status)

	status = activeGraphicDoc->GetActiveSketch(&activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *pCircle = NULL;
	status = activeSketch->CreateLine(CAST(ICurve, pCurve), &pCircle);
	CHECK_RETURN_STATUS(status)

	// Function CreateProjection
	IProjection *pProjection2 = NULL;
	status = CreateProjection(activeSketch, pFaceSet, 1, 1, 0, 0, 2, "TestProjetionCon", &pProjection2);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("CreateProjection");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("TestProjection")
}
